function toggleList(heading, list)
{
    if(heading.className.match('.*expanded')) {
        if (typeof jQuery != 'undefined') {
            jQuery('#'+list).css('display', 'none');
        } else {
            $(list).style.display='none';
        }
        heading.className='loiListHeading collapsed';
    }
    else {
        if (typeof jQuery != 'undefined') {
            jQuery('#'+list).css('display', 'block');
        } else {
            $(list).style.display='block';
        }
        heading.className='loiListHeading expanded';
    }
}


function showXcerpts(aForm)
{
    var x, divs=aForm.getElementsByTagName("div");

    for(x in divs) {
        var div=divs[x];

        if(div.className == 'article-summary' && div.innerHTML.length > 0) {
            var display=div.style.display;

            if(display == 'block')
                div.style.display='none';
            else
                div.style.display='block';
        }
    }
}


function checkEmptyField(aForm)
{
    aForm = document.getElementById(aForm);
    var i, kids=aForm.elements, hasQuery=false;

    for(i in kids) {
        var kid=kids[i];
        if (!kid) {
            continue;
        }

        if (kid.type == "select-one" && kid.value != "" && (kid.name == "AfterYear" || kid.name == "BeforeYear")) {
            hasQuery=true;
            break;
        }

        if(kid.type == "text" && kid.value != "") {
            hasQuery=true;
            break;
        }
    }

    if(!hasQuery) {
        alert("Please enter a search term");
        return false;
    }

    return true;
}


function checkEmptyField(aForm, locale)
{
    aForm = document.getElementById(aForm);
    var i, kids=aForm.elements, hasQuery=false;

    for(i in kids) {
        var kid=kids[i];
        if (!kid) {
            continue;
        }

        if (kid.type == "select-one" && kid.value != "" && (kid.name == "AfterYear" || kid.name == "BeforeYear")) {
            hasQuery=true;
            break;
        }

        if(kid.type == "text" && kid.value != "") {
            hasQuery=true;
            break;
        }
    }

    if(!hasQuery) {
        if(locale == 'de')
            alert("Bitte geben Sie einen Suchbegriff ein.");
        else
            alert("Please enter a search term");
        return false;
    }

    return true;
}

function searchResultPage(aForm, page, aSubject)
{
    getFormInput(aForm.name, 'startPage').value= page;
    aForm.submit();
}


function showHelpDesc(id, msg)
{
    desc=$(id).innerHTML=msg;
}

addListener(window, 'load', function() {
    if (typeof Prototype === 'object') {
        var ac = $('articleContent');
        if (ac) {
            var images = ac.select('.formula img');
            if (images) {
                var maxWidth = ac.getWidth();
                var toggleWidth = function(event) {
                    var element = event.element();
                    var x = element.originalWidth;
                    element.originalWidth = element.width;
                    element.width = x;
                }
                for (var index = 0, len = images.length; index < len; ++index) {
                    var img = images[index];
                    if (img.width > maxWidth) {
                        img.originalWidth = img.width;
                        img.width = maxWidth;
                        img.observe('click', toggleWidth);
                        img.insert({after:'<div class="resizeNote">(Click the equation graphic to enlarge/reduce size)</div>'});
                    }
                }
            }
        }
    }
});

//check if search term is selected in related search
function validateRelatedSearch(formName,checkBoxName){
    var checkBoxes = document.getElementsByName(checkBoxName);
    for(i = 0 ;i < checkBoxes.length ; i++){
        if(checkBoxes[i].checked){
            document.getElementById("relatedSearchValidationDiv").style.display = 'none';
            document.forms[formName].submit();
            return true;
        }
    }
    document.getElementById("relatedSearchValidationDiv").style.display = 'block';
    return false;
}

function validateRelatedSearch(formName,checkBoxName1,checkBoxName2){
    var checkBoxes1 = document.getElementsByName(checkBoxName1);
    var checkBoxes2 = document.getElementsByName(checkBoxName2);
        if(checkBoxSelected(checkBoxes1) || checkBoxSelected(checkBoxes2)){
            document.getElementById("relatedSearchValidationDiv").style.display = 'none';
            document.forms[formName].submit();
            return true;
        }
    document.getElementById("relatedSearchValidationDiv").style.display = 'block';
    return false;
}

function checkBoxSelected(checkBoxes){
    for(i = 0 ;i < checkBoxes.length ; i++){
        if(checkBoxes[i].checked){
            return true;
        }
    }
    return false;
}